// Create the context menu when the extension is installed
chrome.runtime.onInstalled.addListener(() => {
    chrome.contextMenus.create({
        id: "send-to-mixdebrid",
        title: "Generate via MixDebrid",
        contexts: ["link", "selection"] // Show when right-clicking a link OR selected text
    });
});

// Handle the click event on the context menu
chrome.contextMenus.onClicked.addListener((info, tab) => {
    if (info.menuItemId === "send-to-mixdebrid") {
        // Use the selected text if available, otherwise use the link URL
        const targetUrl = info.selectionText ? info.selectionText.trim() : info.linkUrl;

        if (targetUrl) {
            // Construct the MixDebrid URL with the selected link/text as a parameter
            const mixDebridUrl = `https://mixdebrid.com/?url=${encodeURIComponent(targetUrl)}`;

            // Open a new tab in the browser navigating to our web application
            chrome.tabs.create({ url: mixDebridUrl });
        }
    }
});
